// $Id: CClipBoard.cpp,v 1.2 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CClipBoard.hpp"
using Exponent::Host::CClipBoard;

//	===========================================================================
bool CClipBoard::copyStringToSystemClipboard(const CString &text)
{
#ifdef WIN32
	if (OpenClipboard(NULL) != FALSE)
	{
		if (EmptyClipboard() != FALSE)
		{
			const long textLength = text.getNumberOfCharacters();

			// Assign a buffer
			HGLOBAL clipboardBuffer = GlobalAlloc(GHND, (textLength + 1) * sizeof(char));

			// Check that we got the buffer
			if (clipboardBuffer == NULL)
			{
				CloseClipboard();
				return false;
			}

			// Get the string that we are going to paste
			char *str = (char*)GlobalLock(clipboardBuffer);
			strcpy(str, text.getString());
			GlobalUnlock(clipboardBuffer);

			// Copy to the clipboard
			if (SetClipboardData(CF_TEXT, clipboardBuffer) == NULL)
			{
				CloseClipboard();
				return false;
			}

			CloseClipboard();
			return true;
		}
		CloseClipboard();
	}
	return false;
#else
	// Clear the clip board
	ClearCurrentScrap();

	// Get the current clipboard
	ScrapRef scrapReference;
	GetCurrentScrap(&scrapReference);

	// Put the text on to the clipboard
	OSStatus error = PutScrapFlavor(scrapReference, kScrapFlavorTypeText, kScrapFlavorMaskNone, text.getNumberOfCharacters() + 1, text.getString());

	// Check the return type
	if (error == noErr)
	{
		return true;
	}

	return false;
#endif
}

//	===========================================================================
bool CClipBoard::getStringFromSystemClipboard(CString &text)
{
#ifdef WIN32
	if (OpenClipboard(NULL) != FALSE)
	{
		// Get a handle to the clipboard data
        HANDLE clipboardData = GetClipboardData(CF_TEXT);

        if (clipboardData != NULL)
        {
			// Get the string
            const char* str = (const char*)GlobalLock(clipboardData);
            if (str != NULL)
            {
				text = str;
				GlobalUnlock(clipboardData);
				CloseClipboard();
				return true;
            }
        }
        CloseClipboard();
    }
    return false;
#else
	// The reference to the scrap file..
	ScrapRef scrapReference;
	GetCurrentScrap(&scrapReference);

	// The size of the clipboard
	Size clipboardDataSize;

	// Get the size of the data
	OSStatus error = GetScrapFlavorSize(scrapReference, kScrapFlavorTypeText, &clipboardDataSize);

	// Check that there actually is some data
	if (error == noErr && clipboardDataSize > 0)
	{
		// The buffer that will be filled with the clipboard data..
		char *localBuffer = new char[clipboardDataSize + 1];

		// Get the actual data from the clipboard
		if (GetScrapFlavorData(scrapReference, kScrapFlavorTypeText, &clipboardDataSize, localBuffer) == noErr)
		{
			// Store the text
			text = localBuffer;
			FREE_POINTER(localBuffer);
			return true;
		}

		// We failed so we delete the buffer..
		FREE_POINTER(localBuffer);
	}

	return false;
#endif
}